﻿Imports Microsoft.Win32.Registry

Module modMain
    Public AppTitle As String = My.Application.Info.Title       'c't-Uploader
    Public AppName As String = My.Application.Info.AssemblyName 'ctUploader
    Public AppInfo As String = "www.briefblitz.com"
    Public IconsInfo As String = "www.visualpharm.com"
    Public SDInfo As String = "https://skydrive.live.com"

    ' Erlaubte Sonderzeichen für die 7-Zip-Kennworteingabe
    Public Const PWSPECIALCHARS As String = "?!.,;:()[]{}=*/+-$%&#~_ "

    Public Enum FSOType
        File = 0
        Folder = 1
        NotFound = 2
    End Enum

    ' ******************************************************************************************
    ' 7-Zip-Routinen
    ' ******************************************************************************************

    Public Function GetSevenZipPathName() As String
        ' Pfadnamen für 7-Zip-Kommandozeilen-Tool im Ordner dieser Anwendung bilden
        Dim SevenZipPathName As String = My.Computer.FileSystem.CombinePath( _
            My.Application.Info.DirectoryPath, "7z.exe")

        ' Wenn Kommandozeilen-Tool NICHT gefunden, dann...
        If My.Computer.FileSystem.FileExists(SevenZipPathName) = False Then
            ' ... Pfadnamen löschen
            SevenZipPathName = ""
        End If

        ' Pfadnamen zurückgeben
        Return SevenZipPathName
    End Function

    Public Function IsValidPassword(Text As String) As Boolean
        Dim IsValid As Boolean = True
        Dim ValidChars As String = "abcdefghijklmnopqrstuvwxyz" & _
                                   "ABCDEFGHIJKLMNOPQRSTUVWXYZ" & _
                                   "0123456789" & PWSPECIALCHARS

        ' Alle Zeichen von Text durchlaufen
        For Each PWChar As Char In Text
            ' Wenn das aktuelle Zeichen kein gültiges Kennwortzeichen ist, dann...
            If ValidChars.Contains(PWChar) = False Then
                ' ... IsValid auf False setzen
                IsValid = False
                ' Schleife verlassen
                Exit For
            End If
        Next

        ' Wert von IsValid zurückgeben
        Return IsValid
    End Function

    ' ******************************************************************************************
    ' MRU-Handling
    ' ******************************************************************************************

    Public Function String2StringCollection(ByVal SammelString As String, ByVal Delimiter As String) As System.Collections.Specialized.StringCollection
        Dim tempCollection As New System.Collections.Specialized.StringCollection

        For Each EinzelString As String In SammelString.Split(Delimiter)
            If EinzelString > "" Then
                tempCollection.Add(EinzelString)
            End If
        Next

        Return tempCollection
    End Function

    Public Function StringCollection2String(ByVal StringCollection As System.Collections.Specialized.StringCollection, ByVal Delimiter As String) As String
        Dim temp As String = ""

        For Each EinzelString As String In StringCollection
            If EinzelString > "" Then
                temp = temp & Delimiter & EinzelString
            End If
        Next
        If temp.StartsWith(Delimiter) Then
            temp = temp.Substring(1)
        End If

        Return temp
    End Function

    Public Sub SaveToMruList(ByVal MruList As System.Collections.Specialized.StringCollection, _
                             ByVal MruEntry As String, ByVal MruMaxEntries As Integer)
        With MruList
            ' Wenn Eintrag schon in MRU-Liste enthalten ist, dann...
            If .Contains(MruEntry) Then
                ' ... Eintrag daraus entfernen
                ' (sorgt dafür, dass zuletzt geöffneter Eintrag immer am Listenanfang steht)
                .RemoveAt(.IndexOf(MruEntry))
            End If

            ' Übergebenen Eintrag am Anfang der Liste einfügen
            .Insert(0, MruEntry)

            ' Wenn MRU-Liste mehr Einträge als erlaubt enthält, dann...
            If .Count > MruMaxEntries Then
                ' ... letzten Eintrag entfernen
                .RemoveAt(.Count - 1)
            End If
        End With
    End Sub

    Public Sub MruUpdateComboBox(ByVal MruComboBox As ComponentFactory.Krypton.Toolkit.KryptonComboBox, _
                                 ByVal MruList As System.Collections.Specialized.StringCollection)
        ' ComboBox-Liste neu mit MruList-Einträgen füllen
        With MruComboBox
            .Items.Clear()

            For Each MruEntry As String In MruList
                .Items.Add(MruEntry)
            Next
        End With
    End Sub

    ' ******************************************************************************************
    ' Andere Routinen
    ' ******************************************************************************************

    Public Function GetFSOType(FileOrFolder As String) As FSOType
        Dim Result As FSOType = FSOType.NotFound

        Try
            If My.Computer.FileSystem.DirectoryExists(FileOrFolder) Then
                Result = FSOType.Folder
            ElseIf My.Computer.FileSystem.FileExists(FileOrFolder) Then
                Result = FSOType.File
            End If
        Catch ex As Exception
        End Try

        Return Result
    End Function

    Public Function SetBrackets(Text As String)
        ' Text in Klammern zurückgeben
        Return Chr(34) & Text & Chr(34)
    End Function
End Module
